<?php
/*
	#Variaveis
        NOME DO CAMPO
                O QUE 
                TIPO
                OBRIGATRIO ?
                
                
        nCdEmpresa 
                Seu cdigo administrativo junto  ECT. O cdigo est disponvel no corpo do contrato firmado com os Correios.
                String
                No, mas o parmetro tem que ser passado mesmo vazio.
                
        sDsSenha
                Senha para acesso ao servio, associada ao seu cdigo administrativo. A senha inicial corresponde aos 8 primeiros dgitos do CNPJ informado no contrato. A qualquer momento,  possvel alterar a senha no endereo http://www.corporativo.correios.com.br/encomendas/servicosonline/recuperaSenha.
                String
                No, mas o parmetro tem que ser passado mesmo vazio.
                
        nCdServico
                Cdigo do servio
                String
                Sim.Pode ser mais de um numa consulta separados por vrgula.
        
        sCepOrigem
                CEP de Origem sem hfen.Exemplo: 05311900
                String
                Sim
                
        sCepDestino
                CEP de Destino sem hfen
                String
                Sim
        
        nVlPeso
                Peso da encomenda, incluindo sua embalagem. O peso deve ser informado em quilogramas
                Decimal
                Sim,Se o servio no exigir as medidas informar zero.
        
        
        nCdFormato
                Formato da encomenda (incluindo embalagem).Valores possveis: 1 ou 2 (1  Formato caixa/pacote/2  Formato rolo/prisma)
                Int
                Sim
                
        nVlComprimento
                Comprimento da encomenda (incluindo embalagem), em centmetros.
                Decimal
                Sim.Se o servio no exigir medidas informar zero.
                
        nVlAltura
                Altura da encomenda (incluindo embalagem), em centmetros.
                Decimal
                Sim.Se o servio no exigir medidas informar zero.
                
        nVlLargura
                Largura da encomenda (incluindo embalagem), em centmetros.
                Decimal
                Sim.
                Se o servio no exigir medidas informar zero.
                
        nVlDiametro
                Dimetro da encomenda (incluindo embalagem), em centmetros.
                Decimal
                Sim.Se o servio no exigir medidas informar zero.
                
        sCdMaoPropria
                Indica se a encomenda ser entregue com o servio adicional mo prpria.Valores possveis: S ou N (S  Sim, N  No)
                String
                Sim
                        
        nVlValorDeclarado
                Indica se a encomenda ser entregue com o servio adicional valor declarado. Neste campo deve ser apresentado o valor declarado desejado, em Reais.
                Decimal
                Sim.Se no optar pelo servio informar zero.
                
        sCdAvisoRecebimento
                Indica se a encomenda ser entregue com o servio adicional aviso de recebimento.Valores possveis: S ou N (S  Sim, N  No)
                String
                Sim.Se no optar pelo servio informar N
        
/*
	#CDIGOS
		
        # Sem Contrato
        PAC - 41106
        SEDEX - 40010
        SEDEX A COBRAR - 40045
        SEDEX 10 - 40215
        SEDEX HOJE - 40290
        
        #Com Contrato
        SEDEX - 40096 - 40436 - 40444
        E-Sedex - 81019
        PAC - 41068
*/
	ini_set(allow_url_fopen,1);
	
	class FreteCorreios{
			var $nCdEmpresa;
			var $sDsSenha;
			var $nCdServico;
			var $sCepOrigem;
			var $sCepDestino;
			var $nVlPeso;
			var $nCdFormato;
			var $nVlComprimento;
			var $nVlAltura ;
			var $nVlLargura;
			var $nVlDiametro;
			var $sCdMaoPropria;
			var $nVlValorDeclarado;
			var $sCdAvisoRecebimento;
			var $strRetorno;
			var $caminhoCorreios;
			var $xml;
			
			function __construct($servico, $cepOrigem, $cepDestino, $peso, $altura="0", $largura="0", $comprimento="0", $diametro="0", $formato="1", $sCdAvisoRecebimento="n", $maoPropria="n", $valorDeclarado="0") {
				if($altura < 2) $altura = 2;
				if($largura < 5) $largura = 5;
				if($largura < 11 && $comprimento < 25) $largura = 11;
				if($comprimento < 16) $comprimento = 16;
				if($diametro > 0 && $diametro < 5) $diametro = 5;
				
				$this->caminhoWSCorreios		= "http://ws.correios.com.br/calculador/CalcPrecoPrazo.aspx";
				$this->nCdServico				= $servico;
				$this->sCepOrigem				= $cepOrigem;
				$this->sCepDestino				= $cepDestino;
				$this->nVlPeso					= $peso;
				$this->nCdFormato				= $formato; #1  Formato caixa/pacote / 2  Formato rolo/prisma
				$this->nVlComprimento			= $comprimento;
				$this->nVlAltura				= $altura;
				$this->nVlLargura				= $largura;
				$this->nVlDiametro				= $diametro;
				$this->sCdMaoPropria			= $maoPropria; # s OU n
				$this->nVlValorDeclarado		= $valorDeclarado;
				$this->sCdAvisoRecebimento		= $sCdAvisoRecebimento; #s OU n
				$this->strRetorno				= "xml"; #XML / Popup / URL -> sua url
			}
			
			function geraURL(){
				$this->caminhoCorreios = $this->caminhoWSCorreios."?nCdEmpresa=".$this->nCdEmpresa."&sDsSenha =".$this->sDsSenha ."&sCepOrigem=".$this->sCepOrigem."&sCepDestino=".$this->sCepDestino."&nVlPeso=".$this->nVlPeso."&nCdFormato=".$this->nCdFormato."&nVlComprimento=".$this->nVlComprimento."&nVlAltura=".$this->nVlAltura."&nVlLargura=".$this->nVlLargura."&sCdMaoPropria=".$this->sCdMaoPropria."&nVlValorDeclarado=".$this->nVlValorDeclarado."&sCdAvisoRecebimento=".$this->sCdAvisoRecebimento."&nCdServico=".$this->nCdServico."&nVlDiametro=".$this->nVlDiametro."&StrRetorno=".$this->strRetorno;
				
				return $this->caminhoCorreios;
			}
			
			function retornaValor($campo){
				$this->geraURL();
				//Codigo,Valor,PrazoEntrega,ValorMaoPropria,ValorAvisoRecebimento
				//ValorValorDeclarado,EntregaDomiciliar,Entrega Sabado,Erro,MsgErro
				$this->xml = simplexml_load_file($this->caminhoCorreios);
				$this->xml = $this->xml->cServico;
				
				return $this->xml->$campo;
			}
        }
		
		/*
		Cdigo de erro
		Mensagem de erro
		0
		Processamento com sucesso
		-1
		Cdigo de servio invlido
		-2
		CEP de origem invlido
		-3
		CEP de destino invlido
		-4
		Peso excedido
		-5
		O Valor Declarado no deve exceder R$ 10.000,00
		-6
		Servio indisponvel para o trecho informado
		-7
		O Valor Declarado  obrigatrio para este servio
		-8
		Este servio no aceita Mo Prpria
		-9
		Este servio no aceita Aviso de Recebimento
		-10
		Precificao indisponvel para o trecho informado
		-11
		Para definio do preo devero ser informados, tambm, o comprimento, a largura e altura do objeto em centmetros (cm).
		-12
		Comprimento invlido.
		-13
		Largura invlida.
		-14
		Altura invlida.
		-15
		O comprimento no pode ser maior que 60 cm.
		-16
		A largura no pode ser maior que 60 cm.
		-17
		A altura no pode ser maior que 60 cm.
		-18
		A altura no pode ser inferior a 2 cm.
		-19
		A altura no pode ser maior que o comprimento.
		-20
		A largura no pode ser inferior a 5 cm.
		-21
		A largura no pode ser menor que 11cm, quando o comprimento for menor que 25cm.
		-22
		O comprimento no pode ser inferior a 16 cm.
		-23
		A soma resultante do comprimento + largura + altura no deve superar a 150 cm.
		-24
		Comprimento invlido.
		-25
		Dimetro invlido
		-26
		Informe o comprimento.
		-27
		Informe o dimetro.
		-28
		O comprimento no pode ser maior que 90 cm.
		-29
		O dimetro no pode ser maior que 90 cm.
		-30
		O comprimento no pode ser inferior a 18 cm.
		-31
		O dimetro no pode ser inferior a 5 cm.
		-32
		A soma resultante do comprimento + o dobro do dimetro no deve superar a 104 cm.
		-33
		Sistema temporariamente fora do ar. Favor tentar mais tarde.
		-34
		Cdigo Administrativo ou Senha invlidos.
		-35
		Senha incorreta.
		EMPRESA BRASILEIRA DE CORREIOS E TELGRAFOS  ECT
		Manual de Implementao de Clculo Remoto de Preos e Prazos de Encomendas
		12/15
		Manual de Implementacao do Calculo Remoto de Precos e Prazos_versao_1.1.doc  Verso: 1.1
		-36
		Cliente no possui contrato vigente com os Correios.
		-37
		Cliente no possui servio ativo em seu contrato.
		-38
		Servio indisponvel para este cdigo administrativo.
		-888
		Erro ao calcular a tarifa
		7
		Servio indisponvel, tente mais tarde
		99
		Outros erros diversos do .Net
		*/
?>